/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.q_misc_util.my_util.RayTraceResult;

public class BlockManipulationClient {
    private static final class_310 client = class_310.method_1551();
    public static class_5321<class_1937> remotePointedDim;
    public static class_239 remoteHitResult;

    public static boolean isPointingToPortal() {
        return remotePointedDim != null;
    }

    @Nullable
    public static class_638 getRemotePointedWorld() {
        if (remotePointedDim == null) {
            return null;
        }
        return ClientWorldLoader.getWorld(remotePointedDim);
    }

    private static class_3965 createMissedHitResult(class_243 from, class_243 to) {
        class_243 dir = to.method_1020(from).method_1029();
        return class_3965.method_17778((class_243)to, (class_2350)class_2350.method_10142((double)dir.field_1352, (double)dir.field_1351, (double)dir.field_1350), (class_2338)class_2338.method_49638((class_2374)to));
    }

    private static boolean hitResultIsMissedOrNull(class_239 bhr) {
        return bhr == null || bhr.method_17783() == class_239.class_240.field_1333;
    }

    public static void updatePointedBlock(float partialTick) {
        if (BlockManipulationClient.client.field_1761 == null || BlockManipulationClient.client.field_1687 == null || BlockManipulationClient.client.field_1724 == null) {
            return;
        }
        remotePointedDim = null;
        remoteHitResult = null;
        if (!((Predicate)BlockManipulationServer.canDoCrossPortalInteractionEvent.invoker()).test(BlockManipulationClient.client.field_1724)) {
            return;
        }
        class_243 cameraPos = BlockManipulationClient.client.field_1773.method_19418().method_19326();
        double reachDistance = BlockManipulationClient.client.field_1724.method_55754();
        PortalUtils.raytracePortalFromEntityView((class_1297)BlockManipulationClient.client.field_1724, partialTick, reachDistance, true, portal1 -> portal1.isInteractableBy((class_1657)BlockManipulationClient.client.field_1724)).ifPresent(pair -> {
            Portal portal = (Portal)pair.getFirst();
            class_243 hitPos = ((RayTraceResult)pair.getSecond()).hitPos();
            double distanceToPortalPointing = hitPos.method_1022(cameraPos);
            if (distanceToPortalPointing < BlockManipulationClient.getCurrentTargetDistance() + 0.2) {
                BlockManipulationClient.client.field_1765 = BlockManipulationClient.createMissedHitResult(cameraPos, hitPos);
                BlockManipulationClient.updateTargetedBlockThroughPortal(cameraPos, BlockManipulationClient.client.field_1724.method_5828(partialTick), (class_5321<class_1937>)BlockManipulationClient.client.field_1724.method_37908().method_27983(), distanceToPortalPointing, reachDistance, portal);
            }
        });
    }

    private static double getCurrentTargetDistance() {
        class_2338 hitPos;
        class_243 cameraPos = BlockManipulationClient.client.field_1773.method_19418().method_19326();
        if (BlockManipulationClient.hitResultIsMissedOrNull(BlockManipulationClient.client.field_1765)) {
            return 23333.0;
        }
        if (BlockManipulationClient.client.field_1765 instanceof class_3965 && BlockManipulationClient.client.field_1687.method_8320(hitPos = ((class_3965)BlockManipulationClient.client.field_1765).method_17777()).method_26204() == PortalPlaceholderBlock.instance) {
            return 23333.0;
        }
        return cameraPos.method_1022(BlockManipulationClient.client.field_1765.method_17784());
    }

    private static void updateTargetedBlockThroughPortal(class_243 cameraPos, class_243 viewVector, class_5321<class_1937> playerDimension, double beginDistance, double endDistance, Portal portal) {
        class_243 from = portal.transformPoint(cameraPos.method_1019(viewVector.method_1021(beginDistance)));
        class_243 to = portal.transformPoint(cameraPos.method_1019(viewVector.method_1021(endDistance)));
        class_3959 context = new class_3959(from, to, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)BlockManipulationClient.client.field_1724);
        class_638 world = ClientWorldLoader.getWorld(portal.getDestDim());
        remoteHitResult = (class_239)class_1922.method_17744((class_243)from, (class_243)to, (Object)context, (rayTraceContext, blockPos) -> {
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26204() == PortalPlaceholderBlock.instance) {
                return null;
            }
            if (blockState.method_26204() == class_2246.field_10499) {
                return null;
            }
            class_3610 fluidState = world.method_8316(blockPos);
            class_243 start = rayTraceContext.method_17750();
            class_243 end = rayTraceContext.method_17747();
            class_243 correctedStart = start.method_1020(end.method_1020(start).method_1021(0.0015));
            class_265 solidShape = rayTraceContext.method_17748(blockState, (class_1922)world, blockPos);
            class_3965 blockHitResult = world.method_17745(correctedStart, end, blockPos, solidShape, blockState);
            class_265 fluidShape = rayTraceContext.method_17749(fluidState, (class_1922)world, blockPos);
            class_3965 fluidHitResult = fluidShape.method_1092(start, end, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(blockHitResult.method_17784());
            double e = fluidHitResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(fluidHitResult.method_17784());
            return d <= e ? blockHitResult : fluidHitResult;
        }, rayTraceContext -> {
            class_243 vec3d = rayTraceContext.method_17750().method_1020(rayTraceContext.method_17747());
            return class_3965.method_17778((class_243)rayTraceContext.method_17747(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)class_2338.method_49638((class_2374)rayTraceContext.method_17747()));
        });
        if (BlockManipulationClient.remoteHitResult.method_17784().field_1351 < (double)world.method_31607() + 0.1) {
            remoteHitResult = new class_3965(remoteHitResult.method_17784(), class_2350.field_11033, ((class_3965)remoteHitResult).method_17777(), ((class_3965)remoteHitResult).method_17781());
        }
        if (remoteHitResult != null && !world.method_8320(((class_3965)remoteHitResult).method_17777()).method_26215()) {
            BlockManipulationClient.client.field_1765 = BlockManipulationClient.createMissedHitResult(from, to);
            remotePointedDim = portal.getDestDim();
        }
    }

    public static <T> T withSwitchedContext(Supplier<T> func, boolean transformHitResult) {
        class_239 effectiveHitResult;
        class_239 class_2392;
        Validate.notNull((Object)remoteHitResult);
        class_638 remoteWorld = BlockManipulationClient.getRemotePointedWorld();
        Validate.notNull((Object)remoteWorld);
        if (transformHitResult && (class_2392 = remoteHitResult) instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            class_3545<class_3965, class_5321<class_1937>> r = BlockManipulationServer.getHitResultForPlacing((class_1937)remoteWorld, blockHitResult);
            effectiveHitResult = (class_239)r.method_15442();
            remoteWorld = ClientWorldLoader.getWorld((class_5321<class_1937>)((class_5321)r.method_15441()));
            Validate.notNull((Object)remoteWorld);
            Validate.notNull((Object)effectiveHitResult);
        } else {
            effectiveHitResult = remoteHitResult;
        }
        return (T)ClientWorldLoader.withSwitchedWorld(remoteWorld, () -> {
            class_239 originalHitResult = BlockManipulationClient.client.field_1765;
            BlockManipulationClient.client.field_1765 = effectiveHitResult;
            try {
                Object t = func.get();
                return t;
            }
            finally {
                BlockManipulationClient.client.field_1765 = originalHitResult;
            }
        });
    }

    @Nullable
    public static String getDebugString() {
        if (remotePointedDim == null) {
            return null;
        }
        class_239 class_2392 = remoteHitResult;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            return "Point:%s %d %d %d".formatted(remotePointedDim.method_29177(), blockHitResult.method_17777().method_10263(), blockHitResult.method_17777().method_10264(), blockHitResult.method_17777().method_10260());
        }
        return null;
    }
}

